unit mailutil;

interface

uses SysUtils, WinTypes, WinProcs;

procedure BreakLine(const AddrStr : string; var Addr,Name : string);
function JoinLines(const Addr,Name : string) : string;
function SocketErrorStr(ErrNo : word) : string;

implementation

procedure BreakLine(const AddrStr : string; var Addr,Name : string);
{Braek the line with | symbol,
if no |, then assume s=address}
var
  i : byte;
begin
  i:=Pos('|',AddrStr);
  if i=0 then
  begin
    Addr:=AddrStr;
    Name:='';
  end
  else
  begin
    Addr:=Copy(AddrStr,1,i-1);
    Name:=Copy(AddrStr,i+1,Length(AddrStr)-i);
  end;
end;

function JoinLines(const Addr,Name : string) : string;
begin
  Result:=Addr;
  if Name<>'' then
    Result:=Concat(Result,'|',Name);
end;

function SocketErrorStr(ErrNo : word) : string;
var
  LibHandle : THandle;
  Buf : PChar;
begin
  if ErrNo<>0 then
  begin
    LibHandle:=LoadLibrary('wserr.dll');
    if LibHandle>=HINSTANCE_ERROR then
    begin
      Buf:=StrAlloc(255);
      LoadString(LibHandle,ErrNo,Buf,255);
      Result:=StrPas(Buf);
      StrDispose(Buf);
      FreeLibrary(LibHandle);
    end;
    if Result='' then
      Result:='Winsock Error No. '+IntToStr(ErrNo);
  end;
end;

end.
